#include <map>
#include <fstream>
#include <iostream>
#include <cctype>
#include <cassert>

typedef std::map<std::string,int> SLOWNIK;

std::string czytaj_slowo(std::istream &F)            // wczytuje kolejne sowo z F
{
    char c;
    while (F.get(c) && !isalpha(c) && isascii(c))
        continue;                                    // pominicie znakw, ktre nie s literami
    std::string wynik;
    if (!F)                                          // koniec pliku? 
        return wynik;                                // pusty napis
    wynik += tolower(c);                             // zamiana liter duych na mae 
    while(F.get(c) && (isalpha(c) || !isascii(c)) )
        wynik += tolower(c);                         // buduje wyraz z liter
    return wynik;
}

void print_info(std::ostream & F, SLOWNIK const& slownik, std::string const& s)
{
    SLOWNIK::const_iterator iter = slownik.find(s);
    if (iter == slownik.end())
        F << "Sowa \"" << s << "\" nie znaleziono\n";
    else
        F << "Sowo \"" << s << "\" wystpuje " << iter->second << " razy\n";
}

int main(int, char* argv[])
{
    std::ifstream F (argv[1]);                       // nazwa pliku podawana jest z klawiatury!!!
    if (!F)
        exit(1);

    std::cout << "czytam plik '" << argv[1] << "'..." << std::flush;

    SLOWNIK slownik;
    for (std::string s = czytaj_slowo(F); !s.empty(); s = czytaj_slowo(F))
        ++slownik[s];

    std::cout << "\nZnalazem " << slownik.size() << " rnych sw\n";

    print_info(std::cout, slownik, "rafa");
    print_info(std::cout, slownik, "ogary");
    print_info(std::cout, slownik, "komputer");
}
