#include <iostream>
#include <algorithm>     // permutacje
#include <ext/numeric>   // __gnu_cxx::iota 

const int MAX_N = 12;

int check(const signed char tab[], int n) // czy szachuj si po diagonalach? 
{
    bool tmp1[2*MAX_N+1] = {0};
    bool tmp2[2*MAX_N+1] = {0};
    for (int i = 0; i < n; i++)
    {
        int a = tab[i] - i + MAX_N;
        if (tmp1[a] != false )
            return 0;
        tmp1[a] = true;
        int b = tab[i] + i;
        if (tmp2[b] != false )
            return 0;
        tmp2[b] = true; 
    }
    return 1;
}

int ile_hetmanow(const int n) // ile hetmanw mona ustawi na szachownicy n*n?
{
    signed char tab[MAX_N];
    __gnu_cxx::iota(tab, tab + n, 0);  // wypenia tab liczbami 0, 1, 2,..., n-1 
    int wynik = 0;
    bool ok = true;
    while(ok)
    {
        wynik += check(tab, n);  
        ok = std::next_permutation(tab, tab + n);
    }
    return wynik;    
}

int main()
{
    for (int i = 1; i <= MAX_N; ++i)
        std::cout << i << ":\t" << ile_hetmanow(i) << "\n";
}
