#include <set>
#include <fstream>
#include <iostream>
#include <cctype>

typedef std::set<std::string> SET;

std::string czytaj_slowo(std::istream &F)          // wczytuje kolejne sowo z F
{
    char c;
    while (F.get(c) && !isalpha(c) && isascii(c))
        continue;                                  // <-- pominicie nie-liter
    std::string wynik;
    if (!F)                                        // <-- koniec pliku? 
        return wynik;                              // <-- pusty napis
    wynik += tolower(c);
    while(F.get(c) && (isalpha(c) || !isascii(c)) )
        wynik += tolower(c);                       // <-- buduje wyraz z liter
    return wynik;
}

void print_info(std::ostream & F, SET const& zbior, std::string const& s)
{
    SET::const_iterator iter = zbior.find(s);
    if (iter != zbior.end())
        F << "Znaleziono slowo \"" << s << "\"\n";
    else
        F << "Slowa \"" << s << "\" nie znaleziono\n";
}


int main(int, char* argv[])
{
    std::ifstream F (argv[1]);
    if (!F)
        exit(1);

    std::cout << "czytam plik '" << argv[1] << "'..." << std::flush;

    std::set<std::string> zbior;
    for (std::string s = czytaj_slowo(F); !s.empty(); s = czytaj_slowo(F))
        zbior.insert(s);

    std::cout << "\nZnaleziono " << zbior.size() << " roznych slow\n";

    print_info(std::cout, zbior, "rafa");
    print_info(std::cout, zbior, "ogary");
    print_info(std::cout, zbior, "komputer");
}
