#include <cassert>

template<typename T, unsigned N>
class SWektor
{
    T _tab[N];
    
public:
    unsigned   size() const;
    T &        operator[](unsigned n);
    T const&   operator[](unsigned n) const;
};

template<typename T, unsigned N>
inline
unsigned SWektor<T, N>::size() const
{
    return N;
}

template<typename T, unsigned N>
inline
T & SWektor<T, N>::operator[](unsigned n)
{
    assert(n < N);
    return _tab[n];
}

template<typename T, unsigned N>
inline
T const& SWektor<T, N>::operator[](unsigned n) const
{
    assert(n < N);
    return _tab[n];
}

int main()
{
    SWektor<double, 10> v;   // wektor 10 elementw typu double
    SWektor<double, 11> w;   // wektor 11 elementw typu double

    for (unsigned u = 0; u < v.size(); ++u)
        v[u] = w[u] = u;
    w[10] = 0.0;
}
