#include <iostream>
#include <fstream>
#include <vector>
#include <cmath>

class PPMimage
{
public:
   struct Kolor { unsigned char red, green, blue; };

   PPMimage (const char nazwa_pliku[]);      // wczytuje obraz z pliku
   ~PPMimage();
   void zapisz(const char nazwa_pliku[]);    // zapisuje obraz w pliku
   void znieksztalc(int param_x, int param_y);
   void zmiekcz(int r);
   PPMimage(PPMimage const&);             
   
private:
   void operator= (PPMimage const& ) { }     // nie wywouj tej funkcji!
   
   int     _szerokosc; // ilo kolumn w obrazku
   int     _wysokosc;  // ilo wierszy w obrazku
   int     _glebia;    // gbia koloru
   Kolor** _tab;       // adres dwuwymiarowej tablicy kolorw
};

PPMimage::PPMimage(const char nazwa_pliku[])
{
   std::ifstream F(nazwa_pliku, std::ios::binary); // '\n' zajmuje 1 bajt!
   std::string s;                // zmienna pomocnicza
   F >> s >> std::ws;            // teraz s powinno miec wartosc "P6"
   while(F.peek() == '#')        // pominicie ewentualnych komentarzy
      F.ignore(100000, '\n');
   F >> _szerokosc >> _wysokosc >> _glebia;         //wczytanie parametrw obrazu
   F.ignore(100000,'\n');            // pominicie bajtw do znaku '\n' wcznie
   _tab = new Kolor* [_wysokosc];       // przydzia pamici dla adresw wierszy
   for (int i = 0; i < _wysokosc; i++)
   {
      _tab[i] = new Kolor [_szerokosc];  // przydzia pamici dla i-tego wiersza
      char* adres = reinterpret_cast<char*>(_tab[i]);   // zmiana typu wskanika
      F.read(adres , sizeof(Kolor) * _szerokosc);    // wczytanie i-tego wiersza
   }
}


PPMimage::PPMimage(PPMimage const& rhs)
: _szerokosc (rhs._szerokosc), 
  _wysokosc  (rhs._wysokosc), 
  _glebia    (rhs._glebia),
  _tab       (0)
{
   _tab = new Kolor* [_wysokosc];       
   for (int i = 0; i < _wysokosc; i++)
   {
      _tab[i] = new Kolor [_szerokosc]; 
      for (int j = 0; j < _szerokosc; ++j)
         _tab[i][j] = rhs._tab[i][j];
   }
}


void PPMimage::znieksztalc(int param_x, int param_y)
{
   Kolor* p = new Kolor [_szerokosc]; // ''bufor'' na nowy wiersz
   for (int y = 0; y < _wysokosc; y++)
   {
      int dx = int(0.5 + param_x/2.0 * sin(y % param_y * 2*M_PI/param_y) );
      for (int x = 0; x < _szerokosc;x++)
      {
         int index = (x + dx) % _szerokosc;
         if (index < 0)  
             index += _szerokosc;
         p[x] = _tab[y][index];
      }
      std::swap(_tab[y], p);          // podmiana bufora p
   }
   delete [] p;                       // usunicie starego wiersza pikseli
}


void PPMimage::zmiekcz(int r)
{
   PPMimage kopia(*this);  
   int rr = r*r;
   for (int y = 0; y < _wysokosc; ++y)
      for (int x = 0; x < _szerokosc; ++x)
      {
         int mianownik = 0;
         int red = 0, green = 0, blue = 0;
         for (int dx = -r; dx <= r; ++dx)
         { 
            int nx = x + dx;
            if (nx < 0 || nx >= _szerokosc)
               continue;
            for (int dy = -r; dy <= r; ++dy)   
            {
               int ny = y + dy;
               if (ny < 0 || ny >= _wysokosc)
                  continue;
               if (dx*dx + dy*dy > rr)
                  continue;
               mianownik++;
               red   += kopia._tab[ny][nx].red;
               green += kopia._tab[ny][nx].green;
               blue  += kopia._tab[ny][nx].blue;
            }
         }
         _tab[y][x].red = char(0.5 + red / double(mianownik));
         _tab[y][x].green = char(0.5 + green / double(mianownik));
         _tab[y][x].blue = char(0.5 + blue / double(mianownik));
      }  
    
}


void PPMimage::zapisz(const char nazwa_pliku[])
{
   std::ofstream F(nazwa_pliku, std::ios::binary);
   F << "P6\n" << _szerokosc << " " << _wysokosc << "\n" << _glebia << "\n";
   for (int i = 0; i < _wysokosc; i++)
   {
      const char* adres = reinterpret_cast<char*>(_tab[i]);
      F.write(adres, 3 * _szerokosc);
   }
}

PPMimage::~PPMimage()
{
   for (int i = 0;i < _wysokosc; i++)
      delete [] _tab[i];
   delete [] _tab;
}


int main()
{
   PPMimage image("obrazek.ppm");
//   image.znieksztalc(20, 50);
   image.zmiekcz(1);
   image.zapisz("miekki.ppm");
}
