#include <iostream>
#include <fstream>
#include <vector>
#include <cmath>

class PPMimage
{
public:
    struct Kolor { unsigned char red, green, blue; };

    PPMimage (const char nazwa_pliku[]);           // wczytuje obraz z pliku
    ~PPMimage();
    void zapisz(const char nazwa_pliku[]);         // zapisuje obraz w pliku
    void znieksztalc(int param_x, int param_y);
private:
    PPMimage(PPMimage const&) { }                  // nie wywouj tej funkcji!
    void operator= (PPMimage const&) { }           // nie wywouj tej funkcji!
   
    int      _szerokosc;    // liczba kolumn w obrazku
    int      _wysokosc;     // liczba wierszy w obrazku
    int      _glebia;       // gbia koloru
    Kolor**  _tab;          // adres dwuwymiarowej tablicy kolorw
};

PPMimage::PPMimage(const char nazwa_pliku[])
{
    std::ifstream F(nazwa_pliku, std::ios::binary);  // '\n' zajmuje 1 bajt!
    std::string s;                                   // zmienna pomocnicza
    F >> s >> std::ws;                               // teraz s powinno mie warto "P6"
    while(F.peek() == '#')                           // pominicie ewentualnych komentarzy
        F.ignore(100000, '\n');
    F >> _szerokosc >> _wysokosc >> _glebia;         // wczytanie parametrw obrazu
    F.ignore(100000,'\n');                           // pominicie bajtw do znaku '\n' wcznie
    _tab = new Kolor* [_wysokosc];                   // przydzia pamici dla adresw wierszy
    for (int i = 0; i < _wysokosc; ++i)
    {
        _tab[i] = new Kolor [_szerokosc];            // przydzia pamici dla i-tego wiersza
        char* adres = reinterpret_cast<char*>(_tab[i]);      // zmiana typu wskanika
        F.read(adres, sizeof(Kolor) * _szerokosc);           // wczytanie i-tego wiersza
    }
}

void PPMimage::znieksztalc(int param_x, int param_y)
{
    Kolor* p = new Kolor [_szerokosc];               // bufor na nowy wiersz
    for (int y = 0; y < _wysokosc; ++y)
    {
        int dx = int(0.5 + param_x/2.0 * sin(2*M_PI*y/param_y) );
        for (int x = 0; x < _szerokosc;x++)
        {
            int index = (x + dx) % _szerokosc;
            if (index < 0)  
                index += _szerokosc;
            p[x] = _tab[y][index];
        }
        std::swap(_tab[y], p);                       // podmiana bufora p
    }
    delete [] p;                                     // usunicie niepotrzebnego bufora
}

void PPMimage::zapisz(const char nazwa_pliku[])
{
    std::ofstream F(nazwa_pliku, std::ios::binary);
    F << "P6\n" << _szerokosc << " " << _wysokosc << "\n" << _glebia << "\n";
    for (int i = 0; i < _wysokosc; ++i)
        F.write(reinterpret_cast<char*>(_tab[i]), 3 * _szerokosc);
}

PPMimage::~PPMimage() 
{
    for (int i = 0;i < _wysokosc; ++i)
        delete [] _tab[i];
    delete [] _tab;
}

int main()
{
    PPMimage image("obrazek.ppm");
    image.znieksztalc(20, 50);
    image.zapisz("nowy.ppm");
} 
