#include <iostream>
#include <vector>
#include <fstream>
#include <iostream>

struct DzielZero: public std::exception
{
    const char* what() const throw() { return "Dzielenie przez zero!"; }
};

std::vector<double> wczytaj_i_odwroc(std::istream & F)
{
    std::vector<double> wynik;  // <-- lokalny obiekt z niebanalnym destruktorem
    int n;
    while(F >> n)
    {
        if (n == 0)
          throw DzielZero();    // <-- awaryjne zakoczenie funkcji; zgosz. wyjtku
        wynik.push_back(1.0 / n);
    }
    return wynik;               // <-- normalne zakoczenie funkcji
}

int main()
{
   try{
       std::vector<double> v(wczytaj_i_odwroc(std::cin));
       std::cout << "Wczytano " << v.size() << " liczb\n";
   }
   catch(std::exception const& z)
   {
       std::cerr << "zgloszono wyjatek klasy 'std::exception': \"";
       std::cerr << z.what() << "\"\n";
   }
   catch(...)
   {
       std::cerr << "zgloszono wyjatek nieznanego typu!\n";
   }
   std::cout << "koniec programu\n";
}

/*
   catch(std::exception const& z)
   {
       std::cerr << "zgoszono standardowy wyjatek: \"";
       std::cerr << z.what() << "\"\n";
   }
*/
