#include <iostream>

class CialoNiebieskie
{
public:
    CialoNiebieskie (double masa) 
        : _masa (masa)
    {
        std::cout << " Tworzenie ciala niebieskiego o masie " <<  _masa << "\n";
    }
    ~CialoNiebieskie ()
    {
        std::cout << " Niszczenie ciala niebieskiego o masie " <<  _masa << "\n";
    }
    double masa() const   { return _masa; }
private:
    const double _masa;
};

class Gwiazda: public CialoNiebieskie       // Gwiazda jest ciaem niebieskim
{
public:
    Gwiazda (double masa, double jasnosc)
        : CialoNiebieskie (masa), _jasnosc (jasnosc)
    {
        std::cout << " Tworzenie gwiazdy o jasnosci " <<  _jasnosc << "\n";
    }
    ~Gwiazda ()
    {
        std::cout << " Niszczenie gwiazdy o jasnosci " <<  _jasnosc << "\n";
    }
    double jasnosc() const   { return _jasnosc; }
private:
    const double _jasnosc;
};

int main ()
{
    std::cout << "Poczatek funkcji 'main'.\n";
    Gwiazda gwiazdka ( 1234.5, 0.1 );
    std::cout << "Gwiazdka ma mase " << gwiazdka.masa() << " i jasnosc "
              << gwiazdka.jasnosc() << "\n";
    std::cout << "Koniec funkcji 'main'.\n";
}
