#include <map>
#include <fstream>
#include <iostream>
#include <vector>
#include <cctype>

typedef std::pair<std::string, int>  PARA;

struct Porownaj
{
    bool operator()(PARA const& p1, PARA const& p2)
    { return p1.second > p2.second; }
};

std::string wczytaj_slowo(std::istream &F)
{
    char c;
    while (F.get(c) && !isalpha(c) && isascii(c))
        continue;
    std::string wynik;
    if (!F)
        return wynik;
    wynik += tolower(c);
    while(F.get(c) && (isalpha(c) || !isascii(c)) )
        wynik += tolower(c);
    return wynik;
}

int main(int, char* argv[])
{
   std::map<std::string,int> slownik;
   int ile_slow = 0;
   int ile_liter = 0;
   std::ifstream F (argv[1]);
   if (!F)
      exit(1);
   std::cout << "czytam plik '" << argv[1] << "'..." << std::flush;
   for ( ; ; )
   {
      std::string slowo = wczytaj_slowo(F);
      if (slowo.empty())
	 break;
      ile_slow++;
      ++slownik[slowo];
      ile_liter += slowo.size();
    }
    std::cout << "\nOgolem " << ile_liter << " liter, "
              << ile_slow << " slow, w tym "
              << slownik.size() << " roznych" << std::endl;

    std::vector<PARA>  v(slownik.begin(), slownik.end());
    std::stable_sort(v.begin(), v.end(), Porownaj());
    std::ofstream G ("wynik.dat");
    for (unsigned i = 0; i < v.size(); i++)
        G << i+1 << "\t" << v[i].second << "\t" << v[i].first << "\n";
}
