// Program realizujący przeszukiwanie słownika

#include <stdio.h>

struct entry
{
    char  word[15];
    char  definition[50];
};

// Funkcja porównująca dwa łańcuchy znakowe

int compareStrings (const char s1[], const char s2[])
{
    int  i = 0, answer;

    while ( s1[i] == s2[i] && s1[i] != '\0'  &&  s2[i] != '\0' )
        ++i;

    if ( s1[i] < s2[i] )
        answer = -1;            /* s1 < s2 */
    else if ( s1[i] == s2[i] )
        answer = 0 ;            /* s1 == s2 */
    else
        answer = 1;             /* s1 > s2 */

    return answer;
}

// Funkcja odszukująca słowo w słowniku

int lookup (const struct entry dictionary[], const char search[],
            const int entries)
{
    int  low = 0;
    int  high = entries - 1;
    int  mid, result;
    int  compareStrings (const char  s1[], const char s2[]);

    while ( low <= high )
    {
        mid = (low + high) / 2;
        result = compareStrings (dictionary[mid].word, search);

        if ( result == -1 )
            low = mid + 1;
        else if ( result == 1 )
            high = mid - 1;
        else
            return mid;     /* znaleziono */
    }

    return -1;              /* nie znaleziono */
}

int main (void)
{
    const struct entry  dictionary[100] =
      {  { "abakan",    "przestrzenny, monumentalny gobelin" },
         { "abakus",    "starożytne liczydło" },
         { "abazja",    "utrata zdolności chodzenia" },
         { "abduktor",  "mięsień odwodzący kończynę" },
         { "abietyna",  "substancja żywiczna z drzew iglastych" },
         { "abisal",    "najgłębsza strefa mórz, oceanów i jezior" },
         { "abrazja",   "niszczenie wybrzeży przez fale" },
         { "absces",    "inaczej: ropień" },
         { "absynt",    "nalewka spirytusowa na ziołach" },
         { "achterdek", "rufowa część pokładu" } };

    char word[10];
    int  entries = 10;
    int  entry;
    int  lookup (const struct entry dictionary[], const char search[],
                 const int entries);

    printf ("Podaj słowo: ");
    scanf ("%14s", word);
    entry = lookup (dictionary, word, entries);

    if ( entry != -1 )
        printf ("%s\n", dictionary[entry].definition);
    else
        printf ("Niestety, słowo %s nie występuje w moim słowniku.\n", word);

    return 0;
}
