// Program realizujący przeszukiwanie słownika

#include <stdio.h>
#include <stdbool.h>

struct  entry
{
    char   word[15];
    char   definition[50];
};

bool equalStrings (const char  s1[], const char  s2[])
{
    int  i = 0;
    bool areEqual;

    while ( s1[i] == s2 [i]  &&
                 s1[i] != '\0' &&  s2[i] != '\0' )
        ++i;

    if ( s1[i] == '\0'  &&  s2[i] == '\0' )
       areEqual = true;
    else
       areEqual = false;

    return areEqual;
}

// Funkcja odszukująca słowo w słowniku

int lookup (const struct entry dictionary[], const char search[],
            const int entries)
{
    int  i;
    bool equalStrings (const char s1[], const char s2[]);

    for ( i = 0;  i < entries;  ++i )
        if ( equalStrings (search, dictionary[i].word) )
            return i;

    return -1;
}

int main (void)
{
    const struct entry  dictionary[100] =
      {  { "abakan",    "przestrzenny, monumentalny gobelin" },
         { "abakus",    "starożytne liczydło" },
         { "abazja",    "utrata zdolności chodzenia" },
         { "abduktor",  "mięsień odwodzący kończynę" },
         { "abietyna",  "substancja żywiczna z drzew iglastych" },
         { "abisal",    "najgłębsza strefa mórz, oceanów i jezior" },
         { "abrazja",   "niszczenie wybrzeży przez fale" },
         { "absces",    "inaczej: ropień" },
         { "absynt",    "nalewka spirytusowa na ziołach" },
         { "achterdek", "rufowa część pokładu" } };

    char word[10];
    int  entries = 10;
    int  entry;
    int  lookup (const struct entry dictionary[], const char search[],
                 const int entries);

    printf ("Podaj słowo: ");
    scanf ("%14s", word);
    entry = lookup (dictionary, word, entries);

    if ( entry != -1 )
        printf ("%s\n", dictionary[entry].definition);
    else
        printf ("Niestety, słowo %s nie występuje w moim słowniku.\n", word);

    return 0;
}
