#include <Adafruit_NeoPixel.h>
#include <EEPROM.h>

#define RING_PIN    3
#define RING_COUNT 24
#define BUTTON_PIN  2

int previousState = HIGH;
int pause = 250;
int countdown = -1;

const PROGMEM uint32_t colors[] = {
  0xCC000000, 0x00CC0000, 0x0000CC00, 0x000000CC,
  0xCC336699, 0xCC663399, 0xCC339966, 0xCC996633
};
const byte colorCount = 8;
byte colorIndex;

// Deklaracja obiektu NeoPixel zgodnie z dokumentacj dostarczon przez Adafruit
// https://learn.adafruit.com/adafruit-neopixel-uberguide/arduino-library-use

Adafruit_NeoPixel ring(RING_COUNT, RING_PIN, NEO_GRBW);

void setup() {
  Serial.begin(115200);
  pinMode(BUTTON_PIN, INPUT_PULLUP);
  retrieveIndex();          // Pobierz indeks koloru z pamici EEPROM
  ring.begin();             // Zainicjalizuj piercie
  ring.setBrightness(128);  // Ustaw odpowiedni poziom jasnoci
  ring.fill(pgm_read_dword(&colors[colorIndex]));
  ring.show();
}

void loop() {
  int toggle = digitalRead(BUTTON_PIN);
  if (toggle != previousState) {
    if (toggle == LOW) {
      // przycisk wciskany, wic wykonaj odpowiednie dziaanie
      previousState = LOW;
      colorIndex++;
      if (colorIndex >= colorCount) {
        colorIndex = 0;
      }
      ring.fill(pgm_read_dword(&colors[colorIndex]));
      ring.show();
      countdown = 10;
    } else {
      // przycisk zwalniany - jedynie zapisz nowy stan
      previousState = HIGH;
    }
  }
  if (countdown > 0) {
    countdown--;
  } else if (countdown == 0) {
    // Czas upyn! Zapisz biecy indeks koloru w pamici EEPROM
    countdown = -1; // zatrzymaj odliczanie
    storeIndex();
  }
  delay(100);
}

void retrieveIndex() {
  Serial.print(F("ODCZYTYWANIE ... "));
  EEPROM.get(0, colorIndex);
  if (colorIndex < 0 || colorIndex >= colorCount) {
    Serial.println(F("BD, uywamy wartoci domylnej"));
    // Odczytano bdn warto z pamici EEPROM, uyjemy domylnej rwnej 0
    colorIndex = 0;
    // Zapis wartoci poprawnej
    storeIndex();
  } else {
    Serial.print(colorIndex);
    Serial.println(F(" GOTOWE"));
  }
}

void storeIndex() {
  Serial.print(F("ZAPISYWANIE ... "));
  Serial.print(colorIndex);
  EEPROM.put(0, colorIndex);
  Serial.println(F(" GOTOWE"));
}
