#include <stdio.h>

int main() {
  // acuch do zdekodowania
  char source[] = "2P/g/xAARkpG";

  // Wywietlenie acucha rdowego
  printf("%s ==> ", source);

  // Zamy, e nie znamy dugoci acucha
  unsigned char data[60];
  unsigned int index = 0; // bieca pozycja w tablicy dekodowanych danych

  // Wyznacz dugo danych wejciowych
  int source_length = sizeof(source) - 1;

  // Odwr proces kodowania. Uyj 6-bitowych grup rdowych i zamie je
  // na trzy 8-bitowe grupy danych binarnych
  for (int s = 0; s < source_length; s += 4) {
    unsigned char buffer[4];
    for (int b = 0; b < 4; b++) {
      char src = source[s + b]; // uyj kolejnego bajtu z danych rdowych
      if (src >= 'A' && src <= 'Z') {
        // wielka litera, wic warto w zakresie 0 - 25
        buffer[b] = src - 'A';
      } else if (src >= 'a' && src <= 'z') {
        // maa litera, wic warto w zakresie 26 - 51
        buffer[b] = src - 'a' + 26;
      } else if (src >= '0' && src <= '9') {
        // cyfra, wic warto w zakresie 52 - 61
        buffer[b] = src - '0' + 52;
      } else if (src == '+') {
        // znak "+", nie trzeba wykonywa konwersji, przypisz 62
        buffer[b] = 62;
      } else if (src == '/') {
        // znak "/", nie trzeba wykonywa konwersji, przypisz 63
        buffer[b] = 63;
      } else {
        // Bd! Program nie powinien si tu znale
        printf("\n\n Bd! Niepoprawna 6-bitowa warto: %c\n", src);
      }
    }

    data[index] = buffer[0] << 2;
    data[index] |= (buffer[1] & 0x30) >> 4;

    data[index + 1] = (buffer[1] & 0x0f) << 4;
    data[index + 1] |= (buffer[2] & 0x3c) >> 2;

    data[index + 2] = (buffer[2] & 0x03) << 6;
    data[index + 2] |= buffer[3] & 0x3f;

    index += 3;
  }
  
  // Wywietl wyniki
  for (int i = 0; i < index; i++) {
    printf("0x%02x ", data[i]);
  }
  printf("\n");
}