// TMP36 jest 10-bitowym (0 - 1023) czujnikiem analogowym
// o skali 10mV / C z 500mV napiciem wstpnym dla temperatur ujemnych.
// Wywietlacz 4-cyfrowy wykorzystuje ukad TM1637 i protok I2C.
#include <TM1637Display.h>

// Nazwy wyprowadze
#define TMP36_PIN 0
#define CLK       2
#define DIO       3
#define BUTTON    8

// Utwrz obiekt 4-cyfrowego wywietlacza segmentowego
TM1637Display display(CLK, DIO);

// Zdefiniuj litery "F" i "C"
// Bity segmentu s liczone w kierunku zgodnym z ruchem wskazwek zegara
// od gry (bit 1) do rodka (64)
uint8_t segmentF[] = { 1 | 32 | 64 | 16 };
uint8_t segmentC[] = { 1 | 32 | 16 | 8 };

// Wybr skali
bool useC = true;

// Zarzdzanie stanem przycisku wciskanego przez czowieka
bool debounce = false;

void setup() {
  Serial.begin(115200);
  display.clear();
  display.setBrightness(0x0f);
  pinMode(BUTTON, INPUT_PULLUP);
}

void loop() {
  int raw = analogRead(TMP36_PIN);
  float asVolts = raw * 5.0 / 1024;  // Podczenie do zasilania 5V
  float asC = (asVolts - 0.5) * 100;
  int wholeC = (int)(asC + 0.5);
  int wholeF = (int)((asC * 1.8) + 32 + 0.5);
  Serial.print(raw);
  Serial.print(" ");
  Serial.println(asC);
  if (useC) {
    display.showNumberDec(wholeC, false, 3, 0);
    display.setSegments(segmentC, 1, 3);
  } else {
    display.showNumberDec(wholeF, false, 3, 0);
    display.setSegments(segmentF, 1, 3);
  }
  if (debounce) {
    debounce = false;
    delay(1000);
  } else {
    for (int i =0; i < 1000; i += 10) {
      int toggle = digitalRead(BUTTON);
      if (toggle == LOW) {
        useC = !useC;
        debounce = true;
        break;
      }
      delay(10);
    }
  }
}
