#include <SPI.h>
#include <Wire.h>
#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>

// Pobierz informacje uwierzytelniajce z pliku config.h, by uzyska poczenie z chmur
#include "config.h"
AdafruitIO_WiFi io(IO_USERNAME, IO_KEY, WIFI_SSID, WIFI_PASS);
AdafruitIO_Feed *smallerc = io.feed("smallerc");

// Skonfiguruj wywietlacz OLED
#define SCREEN_WIDTH 128 // Szeroko wywietlacza w pikselach
#define SCREEN_HEIGHT 32 // Wysoko wywietlacza w pikselach
#define OLED_RESET     4 // Numer wyprowadzenia do resetowania
#define SCREEN_ADDRESS 0x3C // Patrz karta katalogowa dla ekranu o rozmiarach 128x32 pikseli
Adafruit_SSD1306 display(SCREEN_WIDTH, SCREEN_HEIGHT, &Wire, OLED_RESET);
char statusline[22] = "Uruchamianie...";

// Zmienne pozwalajce wyznacza redni temperatur
float total = 0.0;
int   count = 0;

void setup() {
  Serial.begin(115200);
  // SSD1306_SWITCHCAPVCC = wykorzystaj wewntrzne zasilanie 3,3V
  if(!display.begin(SSD1306_SWITCHCAPVCC, SCREEN_ADDRESS)) {
    Serial.println(F("Problem z uruchomieniem SSD1306"));
    for(;;); // Zatrzymaj si i uyj ptli nieskoczonej
  }

  // Poka ekran powitalny wywietlony przez bibliotek
  display.display();

  // Podcz si do chmury adafruit.io
  Serial.print("czenie z chmur Adafruit IO");
  io.connect();
  // Oczekiwanie na poczenie
  while(io.status() < AIO_CONNECTED) {
    Serial.print(".");
    delay(500);
  }

  // Uzyskano poczenie
  Serial.println();
  Serial.println(io.statusText());


  // Skonfiguruj wywietlacz w celu wywietlania prostych tekstw
  display.clearDisplay();
  display.setTextSize(1);      // Wspczynnik skalowania 1:1
  display.setTextColor(SSD1306_WHITE); // Napisy w kolorze biaym
  display.setCursor(0, 0);     // Tekst rozpoczyna si w lewym grnym naroniku
  display.cp437(true);         // Uyj czcionki o stronie kodowej 437 z 256 znakami
  display.println(statusline);
  display.display();
}

void loop() {
  // Tu powinien si znale gwny kod, ktrego wykonanie bdzie powtarzane w ptli
  int reading = analogRead(A2);
  float voltage = reading / 1024.0;
  if (count == 0) {
    total = voltage;
  } else {
    total += voltage;
  }
  count++;
  float avg = total / count;
  float tempC = (avg - 0.5) * 100;
  float tempF = tempC * 1.8 + 32;
  if (count % 100 == 0) {
    // Aktualizuj wywietlacz co 10 sekund
    display.clearDisplay();
    display.setCursor(0, 0);
    display.println(statusline);
    display.print(reading);
    display.print("  ");
    display.println(voltage);
    display.print(tempC);
    display.println("\370 C");
    display.print(tempF);
    display.println("\370 F");
    display.display();
    strcpy(statusline, "Odczytywanie...");
  }
  if (count % 600 == 0) {
    // Przesyaj dane do chmury co minut
    smallerc->save(tempC);
    strcpy(statusline, "Dane przesane");
  }
  delay(100);
}
