#include <TM1637Display.h>

#define CLK       6
#define DIO       7

#define LEFT_INC_BUTTON  11
#define LEFT_DEC_BUTTON  10
#define RIGHT_INC_BUTTON  3
#define RIGHT_DEC_BUTTON  2

// Utworzenie obiektu wywietlacza czterosegmentowego
TM1637Display display(CLK, DIO);

// Wyniki (0-99) dla obu zespow
byte leftScore  = 0;
byte rightScore = 0;

// Monitorowanie stanu czterech przyciskw
byte leftIncState  = HIGH;
byte leftDecState  = HIGH;
byte rightIncState = HIGH;
byte rightDecState = HIGH;

void updateScores() {
  display.showNumberDecEx(leftScore,0,false,2,0);
  display.showNumberDecEx(rightScore,0,false,2,2);
}

void setup() {
  // Skonfigurowanie wyprowadze dla przyciskw
  pinMode(LEFT_INC_BUTTON, INPUT_PULLUP);
  pinMode(LEFT_DEC_BUTTON, INPUT_PULLUP);
  pinMode(RIGHT_INC_BUTTON, INPUT_PULLUP);
  pinMode(RIGHT_DEC_BUTTON, INPUT_PULLUP);

  // Skonfigurowanie wywietlacza
  display.clear();
  display.setBrightness(0x0f);
  updateScores();
}

void loop() {
  // Sprawdzenie przyciskw
  byte leftInc = digitalRead(LEFT_INC_BUTTON);
  byte leftDec = digitalRead(LEFT_DEC_BUTTON);
  byte rightInc = digitalRead(RIGHT_INC_BUTTON);
  byte rightDec = digitalRead(RIGHT_DEC_BUTTON);

  // Czy ktry z przyciskw jest wanie naciskany?
  if (leftInc == LOW && leftIncState == HIGH) {
    leftScore = constrain(leftScore + 1, 0, 99);
  }
  if (leftDec == LOW && leftDecState == HIGH) {
    leftScore = constrain(leftScore - 1, 0, 99);
  }
  if (rightInc == LOW && rightIncState == HIGH) {
    rightScore = constrain(rightScore + 1, 0, 99);
  }
  if (rightDec == LOW && rightDecState == HIGH) {
    rightScore = constrain(rightScore - 1, 0, 99);
  }

  // Uaktualnienie stanw wszystkich przyciskw
  leftIncState = leftInc;
  leftDecState = leftDec;
  rightIncState = rightInc;
  rightDecState = rightDec;

  // Uaktualnienie tablicy wynikw
  updateScores();
  delay(10);
}
