#include <Adafruit_NeoPixel.h>

#define STICK_PIN   2
#define STICK_COUNT 8
#define RING_PIN    4
#define RING_COUNT 24

// Deklaracja obiektu NeoPixel zgodnie z dokumentacj dostarczon przez Adafruit
// https://learn.adafruit.com/adafruit-neopixel-uberguide/arduino-library-use

Adafruit_NeoPixel stick(STICK_COUNT, STICK_PIN);
Adafruit_NeoPixel ring(RING_COUNT, RING_PIN, NEO_GRBW);

void setup() {
  stick.begin();            // Inicjalizacja komponentu stick (pasek)
  stick.setBrightness(128); // Ustawienie jasnoci
  stick.show();             // Na pocztku wszystkie piksele wyczone
  ring.begin();             // Inicjalizacja komponentu ring (piercie)
  ring.setBrightness(128);  // Ustawienie jasnoci
  ring.show();              // Na pocztku wszystkie piksele wyczone
}

void loop() {
  // Komponenty stick i ring zawieraj odmienne liczby diod LED, wic musimy je
  // odpowiednio obsuy w funkcji loop. Istnieje kilka rozwiza.
  // W tym przypadku zastosujemy operacj modulo. Czy moesz wymyli inny sposb,
  // dziki ktremu mona byoby uzyska ten sam rezultat?
  for (int p = 0; p < RING_COUNT; p++) {
    stick.clear();
    stick.setPixelColor(p % STICK_COUNT, 0, 0, 255);
    ring.clear();
    ring.setPixelColor(p, 0, 255, 0, 0);
    
    stick.show();
    ring.show();
    delay(1000);
  }
}
