/*
 * Decompiled with CFR 0.152.
 */
package com.packtpub.as7development.chapter3.timer;

import com.packtpub.as7development.chapter3.ejb.TheatreBox;
import com.packtpub.as7development.chapter3.model.Seat;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Schedule;
import javax.ejb.Stateless;
import javax.ejb.Timer;
import javax.ejb.TimerService;

@Stateless
public class AutomaticSellerBean {
    private static final Logger logger = Logger.getLogger(AutomaticSellerBean.class.getName());
    @EJB
    private TheatreBox theatreBox;
    @Resource
    private TimerService timerService;

    @Schedule(dayOfWeek="*", hour="*", minute="*", second="*/60", year="*", persistent=false)
    public void automaticCustomer() {
        int seatId = this.findSeat();
        if (seatId == -1) {
            this.cancelTimers();
            logger.info("Koniec wykonywania harmonogramu!");
            return;
        }
        this.theatreBox.buyTicket(seatId);
        logger.info("Kto\u015b w\u0142a\u015bnie zarezerwowa\u0142 miejsce " + (seatId + 1));
    }

    private int findSeat() {
        ArrayList<Seat> list = this.theatreBox.getSeatList();
        for (Seat s : list) {
            if (s.isBooked()) continue;
            return s.getId() - 1;
        }
        return -1;
    }

    private void cancelTimers() {
        for (Timer timer : this.timerService.getTimers()) {
            timer.cancel();
        }
    }
}

