/**
   Ta klasa przechowuje w tablicy wartoci sprzeday 
   z okrelonej liczby dni i udostpnia metody do pobierania
   sumy i redniej wartoci sprzeday, a take najwyszej
   i najniszej wartoci sprzeday.
*/

public class SalesData
{
   private double[] sales; // Dane sprzedaowe.

   /**
      Konstruktor kopiuje elementy otrzymanej 
      tablicy do tablicy sales.
      @param s Kopiowana tablica.
   */

   public SalesData(double[] s)
   {
      // Tworzenie tablicy o wielkoci rwnej dugoci tablicy s.
      sales = new double[s.length];
      
      // Kopiowanie elementw z tablicy s do tablicy sales.
      for (int index = 0; index < s.length; index++)
         sales[index] = s[index];
   }

   /**
      Metoda getTotal.
      @return Suma wartoci elementw
              tablicy sales.
   */

   public double getTotal()
   {
      double total = 0.0;     // Akumulator.

      // Sumowanie wartoci elementw 
      // tablicy sales.
      for (int index = 0; index < sales.length; index++)
         total += sales[index];

      // Zwracanie sumy.
      return total;
   }

   /**
      Metoda getAverage.
      @return rednia warto elementw
              tablicy sales.
   */

   public double getAverage()
   {
      return getTotal() / sales.length;
   }

   /**
      Metoda getHighest.
      @return Najwiksza warto przechowywana
              w tablicy sales.
   */

   public double getHighest()
   {
      double highest = sales[0];

      for (int index = 1; index < sales.length; index++)
      {
         if (sales[index] > highest)
            highest = sales[index];
      }

      return highest;
   }

   /**
      Metoda getLowest.
      @return Najmniejsza warto przechowywana
              w tablicy sales.
   */

   public double getLowest()
   {
      double lowest = sales[0];

      for (int index = 1; index < sales.length; index++)
      {
         if (sales[index] < lowest)
            lowest = sales[index];
      }

      return lowest;
   }
}