/**
 * Ten program ilustruje uywanie metadanych zbioru wynikw.
 */

import java.sql.*;
import java.util.Scanner;

public class MetaDataDemo
{
   public static void main(String[] args) throws Exception
   {
      // Tworzenie staej z adresem URL.
      // UWAGA: Ta warto jest specyficzna dla systemw Java DB i Apache Derby.
      final String DB_URL = "jdbc:derby:CoffeeDB";
      
      try
      {
         // Tworzenie obiektu typu Scanner do pobierania danych z klawiatury.
         Scanner keyboard = new Scanner(System.in);
         
         // Pobieranie instrukcji SELECT od uytkownika.
         System.out.println("Podaj instrukcj SELECT " +
                            "kierowan do bazy danych CoffeeDB:");
         String sql = keyboard.nextLine();
         
         // Nawizywanie poczenia z baz.
         Connection conn =
                DriverManager.getConnection(DB_URL);
            
         // Tworzenie obiektu typu Statement.
         Statement stmt = conn.createStatement();
            
         // Wykonywanie zapytania.
         ResultSet resultSet = stmt.executeQuery(sql);
            
         // Pobieranie metadanych zbioru wynikw.
         ResultSetMetaData meta = resultSet.getMetaData();
            
         // Wywietlanie liczby zwrconych kolumn.
         System.out.println("Liczba kolumn w zbiorze wynikw: " +
                            meta.getColumnCount() +
                            ".");
                               
         // Wywietlanie nazw i typw danych kolumn.
         for (int i = 1; i <= meta.getColumnCount(); i++)
         {
            System.out.println(meta.getColumnName(i) + ", " +
                               meta.getColumnTypeName(i));
         }
            
         // Wywietlanie zawartoci wierszy.
         System.out.println("\nOto wiersze ze zbioru wynikw:");
         while (resultSet.next())
         {
            // Wywietlanie wiersza.
            for (int i = 1; i <= meta.getColumnCount(); i++)
            {
               System.out.print(resultSet.getString(i));
            }
            System.out.println();
         }
   
         // Zamykanie obiektu stmt i poczenia.
         stmt.close();
         conn.close();
      }
      catch(Exception ex)
      {
         System.out.println("BD: " + ex.getMessage());
      }     
   }
}