/**
   Ta klasa wywietla rozwizanie amigwki
   Wiee Hanoi.
*/

public class Hanoi
{
   private int numDiscs;   // Liczba dyskw.
   
   /**
      Konstruktor.
      @param n Liczba uywanych dyskw.
   */
   
   public Hanoi(int n)
   {
      // Przypisywanie liczby dyskw.
      numDiscs = n;

      // Przenoszenie dyskw z koka 1 na koek 3
      // z uyciem koka 2 jako tymczasowego.
      moveDiscs(numDiscs, 1, 3, 2);
   }

   /**
      Metoda moveDiscs wywietla ruchy dyskw.
      @param num Liczba przenoszonych dyskw.
      @param fromPeg Pocztkowy koek.
      @param toPeg Docelowy koek.
      @param tempPeg Tymczasowy koek.
   */
   
   private void moveDiscs(int num, int fromPeg,
                          int toPeg, int tempPeg)
   {
      if (num > 0)
      {
         moveDiscs(num - 1, fromPeg, tempPeg, toPeg);
         System.out.println("Przenie dysk z koka " +
                           fromPeg + " na koek " + toPeg + ".");
         moveDiscs(num - 1, tempPeg, toPeg, fromPeg);
      }
   }
}
