import javafx.application.Application;
import javafx.stage.Stage;
import javafx.scene.Scene;
import javafx.scene.layout.HBox;
import javafx.scene.control.Label;
import javafx.geometry.Pos;

public class MouseMovedDemo extends Application
{
   public static void main(String[] args)
   {
      // Uruchamianie aplikacji.
       launch(args);
   }
  
   @Override
   public void start(Stage primaryStage)
   {
      // Stae okrelajce wielko sceny.
      final double SCENE_WIDTH = 200.0;
      final double SCENE_HEIGHT = 200.0;
      
      // Tworzenie etykiety.
      Label label = new Label("Przesu kursor myszy.");

      // Dodawanie etykiety do kontenera typu Pane.
      HBox hbox = new HBox(label);
      hbox.setAlignment(Pos.CENTER);
      
      // Tworzenie sceny.
      Scene scene = new Scene(hbox, SCENE_WIDTH, SCENE_HEIGHT);
      
      // Rejestrowanie dla sceny obiektu obsugi zdarze 
      // typu MOUSE_MOVED.
      scene.setOnMouseMoved(event ->
      {
         // Pobieranie wsprzdnych kursora myszy.
         double x = event.getSceneX();
         double y = event.getSceneY();
         
         // Wywietlanie lokalizacji kursora myszy.
         label.setText(String.format("%.0f, %.0f", x, y));
      });

      // Przypisywanie sceny do ptna i jej wywietlanie.
      primaryStage.setScene(scene);
      primaryStage.show();
   }
}
