import javafx.application.Application;
import javafx.stage.Stage;
import javafx.scene.Scene;
import javafx.scene.layout.VBox;
import javafx.scene.control.Label;
import javafx.scene.control.Button;
import javafx.geometry.Pos;

/**
 *  Przycisk z obsug zdarze z uyciem wyrae lambda.
 */

public class LambdaDemo extends Application
{
   public static void main(String[] args)
   {
      // Uruchamianie aplikacji.
      launch(args);
   }
   
   @Override
   public void start(Stage primaryStage)
   {
      // Tworzenie etykiety.
      Label myLabel = new Label("Kliknij przycisk, aby zobaczy komunikat.");
      
      // Tworzenie przycisku.
      Button myButton = new Button("Kliknij mnie");
      myButton.setOnAction(event ->
      {
         myLabel.setText("Dzikujemy za kliknicie przycisku.");
      });
      
      // Dodawanie etykiety i przycisku do kontenera typu VBox z odstpami wielkoci 10 pikseli.
      VBox vbox = new VBox(10, myLabel, myButton);
      
      // Tworzenie sceny z kontenerem typu VBox jako wzem korzenia.
      Scene scene = new Scene(vbox, 300, 100);
      
      // Wyrodkowanie zawartoci sceny.
      vbox.setAlignment(Pos.CENTER);
      
      // Dodawanie sceny do ptna.
      primaryStage.setScene(scene);
      
      // Ustawianie tytuu ptna.
      primaryStage.setTitle("LambdaDemo");
      
      // Wywietlanie okna.
      primaryStage.show();
   }
}