/**
   Klasa Telephone udostpnia statyczne metody
   do formatowania i usuwania formatowania amerykaskich 
   numerw telefonw.
*/
 
public class Telephone
{
   // Te stae przechowuj poprawn dugo acuchw znakw 
   // w sformatowanej i niesformatowanej postaci.
   public final static int FORMATTED_LENGTH = 13;
   public final static int UNFORMATTED_LENGTH = 10;
   
   /**
      Metoda isFormatted okrela, czy acuch znakw 
      jest poprawnie sformatowany jako amerykaski
      numer telefonu i ma posta:
      (XXX)XXX-XXXX
      @param str Sprawdzany acuch znakw.
      @return true, jeli acuch znakw jest poprawnie sformatowany,
              i false w przeciwnym razie.
   */

   public static boolean isFormatted(String str)
   {
      boolean valid;  // Flaga informujca, czy format jest poprawny.

      // Okrelanie, czy acuch str jest poprawnie sformatowany.
      if (str.length() == FORMATTED_LENGTH && 
          str.charAt(0) == '(' &&
          str.charAt(4) == ')' &&
          str.charAt(8) == '-')
          valid = true;
      else
         valid = false;
      
      // Zwracanie wartoci flagi valid.
      return valid;
   }
   
   /**
      Metoda unformat przyjmuje acuch znakw zawierajcy
      numer telefonu w formacie:
      (XXX)XXX-XXXX.
      Jeli argument jest sformatowany w ten sposb, metoda
      zwraca niesformatowany acuch znakw, z usunitym 
      nawiasem i mylnikiem. W przeciwnym razie
      zwraca niezmodyfikowany argument.
      @param str acuch znakw, ktrego formatowanie naley usun.
      @return Niesformatowany acuch znakw.
   */
    
   public static String unformat(String str)
   {
      // Tworzenie obiektu typu StringBuilder inicjowanego parametrem str.
      StringBuilder strb = new StringBuilder(str);
      
      // Jeli argument jest poprawnie sformatowany, naley
      // usun formatowanie.
      if (isFormatted(str))
      {
         // Najpierw naley usun lewy nawias z pozycji 0.
         strb.deleteCharAt(0);

         // Nastpnie usuwany jest prawy nawias. Z powodu
         // wczeniejszego usuwania znajduje
         // si on teraz na pozycji 3.
         strb.deleteCharAt(3);

         // Nastpnie usuwany jest mylnik. Z powodu
         // wczeniejszych operacji usuwania mylnik
         // znajduje si teraz na pozycji 6.
         strb.deleteCharAt(6);
      }
      
      // Zwracanie niesformatowanego acucha znakw.
      return strb.toString();
   }
   
   /**
      Metoda format formatuje acuch znakw do postaci:
      (XXX)XXX-XXXX.
      Jeli dugo argumentu to UNFORMATTED_LENGTH,
      metoda zwraca sformatowany acuch znakw. W przeciwnym
      razie zwraca niezmodyfikowany argument.
      @param str Formatowany acuch znakw.
      @return acuch znakw sformatowany jako amerykaski numer telefonu.
   */
    
   public static String format(String str)
   {
      // Tworzenie obiektu typu StringBuilder zainicjowanego parametrem str.
      StringBuilder strb = new StringBuilder(str);

      // Jeli argument ma prawidow dugo, naley
      // go sformatowa.
      if (str.length() == UNFORMATTED_LENGTH)
      {
         // Najpierw naley wstawi lewy nawias na pozycji 0.
         strb.insert(0, "(");
            
         // Najpierw naley wstawi prawy nawias na pozycji 4.
         strb.insert(4, ")");
            
         // Najpierw naley wstawi mylnik na pozycji 8.
         strb.insert(8, "-");
      }
      
      // Zwracanie sformatowanego acucha znakw.
      return strb.toString();
   }
}