/**
   Ta klasa przechowuje dane na temat podrcznika.
*/

public class TextBook
{
   private String title;     // Tytu podrcznika.
   private String author;     // Nazwisko autora.
   private String publisher;  // Nazwa wydawnictwa.

   /**
     Ten konstruktor inicjuje pola title,
     author i publisher.
     @param textTitle Tytu ksiki.
     @param auth Nazwisko autora.
     @param pub Nazwa wydawnictwa.
   */

   public TextBook(String textTitle, String auth,
                   String pub)
   {
      title = textTitle;
      author = auth;
      publisher = pub;
   }

   /**
      Konstruktor kopiujcy inicjuje obiekt 
      jako kopi innego obiektu typu TextBook.
      @param object2 Kopiowany obiekt.
   */

   public TextBook(TextBook object2)
   {
      title = object2.title;
      author = object2.author;
      publisher = object2.publisher;
   }

   /**
      Metoda set ustawia warto kadego pola.
      @param textTitle Tytu podrcznika.
      @param auth Nazwisko autora.
      @param pub Nazwa wydawnictwa.
   */

   public void set(String textTitle, String auth,
                   String pub)
   {
      title = textTitle;
      author = auth;
      publisher = pub;
   }

   /**
      Metoda toString.
      @return acuch znakw zawierajcy
            informacje o podrczniku.
   */

    public String toString()
    {
      // Tworzenie acucha znakw reprezentujcego dany obiekt.
      String str = "Tytu: " + title +
                   "\nAutor: " + author +
                   "\nWydawnictwo: " + publisher;

      // Zwracanie acucha znakw.
      return str;
   }
}