/**
   Ten program ilustruje dziaanie metody, ktra
   przyjmuje zmienn liczb argumentw.
*/

public class VarargsDemo2
{
   public static void main(String[] args)
   {
      double total;  // Przechowywanie sumy stanw kont.

      // Tworzenie obiektu BankAccount ze stanem konta 100.
      BankAccount account1 = new BankAccount(100.0);
      
      // Tworzenie obiektu BankAccount ze stanem konta 500.
      BankAccount account2 = new BankAccount(500.0);
      
      // Tworzenie obiektu BankAccount ze stanem konta 1500.
      BankAccount account3 = new BankAccount(1500.0);
      
      // Wywoanie metody z jednym argumentem.
      total = totalBalance(account1);
      System.out.println("Suma: " + total + " zotych.");

      // Wywoanie metody z dwoma argumentami.
      total = totalBalance(account1, account2);
      System.out.println("Suma: " + total + " zotych.");
      
      // Wywoanie metody z trzema argumentami.
      total = totalBalance(account1, account2, account3);
      System.out.println("Suma: " + total + " zotych.");
    }

    /**
      Metoda totalBalance przyjmuje zmienn liczb
      obiektw typu BankAccount i zwraca sum ich
      stanw kont.
      @param accounts Konto lub konta.
      @return Suma stanw kont.
   */
   
   public static double totalBalance(BankAccount... accounts)
   {
      double total = 0.0;  // Akumulator.

      // Dodawanie wszystkich wartoci z obiektw z tablicy accounts.
      for (BankAccount acctObject : accounts)
         total += acctObject.getBalance();
      
      // Zwracanie sumy.
      return total;
   }
}