import java.util.Scanner;

public class ChoHan
{
   public static void main(String[] args)
   {
      final int MAX_ROUNDS = 5;  // Liczba rund.
      String player1Name;        // Imi pierwszego gracza.
      String player2Name;        // Imi drugiego gracza.

      // Tworzenie obiektu typu Scanner do pobierania danych z klawiatury.
      Scanner keyboard = new Scanner(System.in);
      
      // Pobieranie imion graczy.
      System.out.print("Podaj imi pierwszego gracza: ");
      player1Name = keyboard.nextLine();
      System.out.print("Podaj imi drugiego gracza: ");
      player2Name = keyboard.nextLine();
      
      // Tworzenie obiektu reprezentujcego krupiera.
      Dealer dealer = new Dealer();
      
      // Tworzenie obiektw reprezentujcych dwch graczy.
      Player player1 = new Player(player1Name);
      Player player2 = new Player(player2Name);
      
      // Rozgrywanie rund.
      for (int round = 0; round < MAX_ROUNDS; round++)
      {
        System.out.println("----------------------------");
        System.out.printf("Runda numer %d.\n", round + 1);
 
         // Rzut kostkami.
         dealer.rollDice();
         
         // Typowanie wyniku przez graczy.
         player1.makeGuess();
         player2.makeGuess();
         
         // Okrelanie zwycizcy danej rundy.
         roundResults(dealer, player1, player2);
      }
      
      // Wywietlanie zwycizcy caej gry.
      displayGrandWinner(player1, player2);
   }
   
   /**
      Metoda roundResults okrela wyniki
      biecej rundy.
      @param dealer Obiekt typu Dealer (reprezentuje krupiera).
      @param player1 Obiekt reprezentujcy gracza numer 1.
      @param player2 Obiekt reprezentujcy gracza numer 2.
   */
   
   public static void roundResults(Dealer dealer, Player player1,
                                   Player player2)
   {
      // Wywietlanie wartoci rzutw.
      System.out.printf("Krupier wyrzuci %d i %d.\n",
                        dealer.getDie1Value(), dealer.getDie2Value());
      System.out.printf("Wynik: %s\n", dealer.getChoOrHan());

      // Sprawdzanie typw obu graczy i przyznawanie punktw.
      checkGuess(player1, dealer);
      checkGuess(player2, dealer);
   }
   
   /**
      Metoda checkGuess porwnuje typowanie gracza
      z wynikiem uzyskanym przez krupiera.
      @param player Sprawdzany obiekt typu Player (reprezentuje gracza).
      @param dealer Obiekt typu Dealer (reprezentuje krupiera).
   */

   public static void checkGuess(Player player, Dealer dealer)
   {
      final int POINTS_TO_ADD = 1; // Punkty przyznawane zwycizcy.
      String guess = player.getGuess();           // Typ gracza.
      String choHanResult = dealer.getChoOrHan(); // Cho lub Han.

      // Wywietlanie typowania gracza.
      System.out.printf("Gracz %s wytypowa %s.\n",
                         player.getName(), player.getGuess());
      
      // Przyznawanie punktw, jeli gracz poprawnie wytypowa wynik.
      if (guess.equalsIgnoreCase(choHanResult))
      {
         player.addPoints(POINTS_TO_ADD);
         System.out.printf("Punkty przyznane graczowi %d to %s.\n",
                           POINTS_TO_ADD, player.getName());
      }
   }

   /**
      Metoda displayGrandWinner wywietla zwycizc caej gry.
      @param player1 Gracz numer 1.
      @param player2 Gracz numer 2.
   */
   
   public static void displayGrandWinner(Player player1, Player player2)
   {
      System.out.println("----------------------------");
      System.out.println("Koniec gry. Oto wyniki:");
      System.out.printf("%s: liczba punktw = %d.\n", player1.getName(),
                        player1.getPoints());
      System.out.printf("%s: liczba punktw = %d.\n", player2.getName(),
                        player2.getPoints());
      
      if (player1.getPoints() > player2.getPoints())
         System.out.println(player1.getName() + " wygra ca gr!");
      else if (player2.getPoints() > player1.getPoints())
        System.out.println(player2.getName() + " wygra ca gr!");
      else
        System.out.println("Remis!");
   }
}