/**
   Ten program pokazuje, e typ w postaci interfejsu
   mona wykorzysta do tworzenia referencji polimorficznych.
*/

public class PolymorphicInterfaceDemo
{
   public static void main(String[] args)
   {
      // Tworzenie obiektu typu CompactDisc.
      CompactDisc cd =
              new CompactDisc("Greatest Hits",
                              "Joe Looney Band",
                              18.95);
      // Tworzenie obiektu typu DvdMovie.
      DvdMovie movie =
              new DvdMovie("Wheels of Fury",
                           137, 12.95);

      // Wywietlanie tytuu pyty CD.                   
      System.out.println("Item #1: " +
                         cd.getTitle());
                         
      // Wywietlanie ceny pyty CD.
      showPrice(cd);
      
      // Wywietlanie tytuu pyty DVD.
     System.out.println("Produkt numer 2: " +
                         movie.getTitle());
                         
      // Wywietlanie ceny pyty DVD.
      showPrice(movie);
   }

   /**
      Metoda showPrice wywietla cen
      obiektu typu RetailItem.
      @param item Referencja do obiektu typu RetailItem.
   */
   
   private static void showPrice(RetailItem item)
   {
      System.out.printf("Cena: %,.2f zotych.\n", item.getRetailPrice());
   }
}
