/**
   Ta klasa okrela ocen z egzaminu kocowego.
*/

public class FinalExam3 extends GradedActivity implements Relatable
{
   private int numQuestions;  // Liczba pyta.
   private double pointsEach; // Liczba punktw za kade pytanie.
   private int numMissed;     // Liczba bdnych odpowiedzi.

   /**
     Konstruktor ustawia liczb pyta na egzaminie
     i liczb bdnych odpowiedzi.
     @param questions Liczba pyta.
     @param missed Liczba bdnych odpowiedzi.
   */

   public FinalExam3(int questions, int missed)
   {
      double numericScore;  // Przechowuje wynik punktowy.

      // Ustawianie wartoci pl numQuestions i numMissed.
      numQuestions = questions;
      numMissed = missed;

      // Obliczanie liczby punktw za kade pytanie
      // i wyniku punktowego z egzaminu.
      pointsEach = 100.0 / questions;
      numericScore = 100.0 - (missed * pointsEach);

      // Wywoanie odziedziczonej metody setScore 
      // w celu ustawienia wyniku punktowego.
      setScore(numericScore);
   }

   /**
      Metoda getPointsEach zwraca liczb punktw
      przyznawanych za kade pytanie.
      @return Warto pola pointsEach.
   */

   public double getPointsEach()
   {
      return pointsEach;
   }

   /**
      Metoda getNumMissed zwraca liczb
      bdnych odpowiedzi.
      @return Warto pola numMissed.
   */

   public int getNumMissed()
   {
      return numMissed;
   }

   /**
      Metoda equals sprawdza, czy obiekt zawierajcy wywoan metod
      jest rwny wzgldem obiektu przekazanego jako argument.
      @return Warto true, jeli pole score w obiekcie zawierajcym 
              wywoany obiekt ma warto rwn polu score obiektu
              przekazanego jako argument.
   */

   public boolean equals(GradedActivity g)
   {
      boolean status; 

      if (this.getScore() == g.getScore())
         status = true;
      else
         status = false;

      return status;
   }

   /**
      Metoda isGreater okrela, czy obiekt zawierajcy wywoan metod
      jest wikszy ni obiekt przekazany jako argument.
      @return Warto true, jeli pole score w obiekcie zawierajcym wywoan metod
              ma warto wiksz ni pole score w obiekcie przekazanym jako argument.
   */

   public boolean isGreater(GradedActivity g)
   {
      boolean status; 

      if (this.getScore() > g.getScore())
         status = true;
      else
         status = false;

      return status;
   }

   /**
      Metoda isLess okrela, czy obiekt zawierajcy wywoan metod
      jest mniejszy ni obiekt przekazany jako argument.
      @return Warto true, jeli pole score w obiekcie zawierajcym wywoan metod
              ma warto mniejsz ni pole score w obiekcie przekazanym jako argument.
   */

   public boolean isLess(GradedActivity g)
   {
      boolean status; 

      if (this.getScore() < g.getScore())
         status = true;
      else
         status = false;

      return status;
   }
}