/**
   Ta klasa przechowuje dane o prostopadocianie.
*/

public class Cube extends Rectangle
{
   private double height;  // Wysoko prostopadocianu.

   /**
      Ten konstruktor ustawia dugo, 
      szeroko i wysoko prostopadocianu.
      @param len Dugo prostopadocianu.
      @param w Szeroko prostopadocianu.
      @param h Wysoko prostopadocianu.
   */

   public Cube(double len, double w, double h)
   {
      // Wywoanie konstruktora klasy bazowej.
      super(len, w);

      // Ustawianie wysokoci.
      height = h;
   }

   /**
     Metoda getHeight zwraca wysoko prostopadocianu.
     @return Warto pola height.
   */

   public double getHeight()
   {
      return height;
   }

   /**
      Metoda getSurfaceArea oblicza i zwraca
      pole cakowite prostopadocianu.
      @return Pole cakowite prostopadocianu.
   */
   
   public double getSurfaceArea()
   {
      return getArea() * 6;
   }

   /**
      Metoda getVolume oblicza i zwraca
      objto prostopadocianu.
      @return Objto prostopadocianu.
   */
   
   public double getVolume()
   {
      return getArea() * height;
   }
}