import java.util.Random;

/**
   Klasa Player do gry Cho-Han.
*/
   
public class Player
{
   private String name;   // Imi gracza.
   private String guess;  // Warto podana przez gracza.
   private int points;    // Liczba punktw gracza.

   
   /**
      Konstruktor
      @param playerName Imi gracza.
   */
   
   public Player(String playerName)
   {
      name = playerName;
      guess = "";
      points = 0;
   }
   
   /**
      Metoda makeGuess typuje wynik:
      "Cho (nieparzyste)" lub "Han (parzyste)".
   */
   
   public void makeGuess()
   {
      // Tworzenie obiektu typu Random.
     Random rand = new Random();

     // Pobieranie liczby losowej 0 lub 1.
     int guessNumber = rand.nextInt(2);

     // Przeksztacanie liczby losowej na wybr
     // "Cho (parzyste)" lub "Han (nieparzyste)".
     if (guessNumber == 0)
       guess = "Cho (parzyste)";
     else
       guess = "Han (nieparzyste)";
   }
   
   /**
      Metoda addPoints dodaje okrelon liczb
     punktw do aktualnej punktacji gracza.
     @newPoints Liczba dodawanych punktw.
   */
   
   public void addPoints(int newPoints)
   {
      points += newPoints;
   }
   
   /**
      Metoda getName zwraca imi gracza.
      @return Warto pola name.
   */
   
   public String getName()
   {
      return name;
   }

   /**
      Metoda getGuess zwraca wytypowany przez gracza wynik.
      @return Warto pola guess.
   */
   
   public String getGuess()
   {
      return guess;
   }

   /**
      Metoda getPoints zwraca liczb punktw gracza.
      @return Warto pola points.
   */
   
   public int getPoints()
   {
      return points;
   }
}