import java.util.Scanner;   // Potrzebne, by mc uywa klasy Scanner.
import java.io.*;          // Potrzebne, by mc uywa klasy File i wyjtkw IOException.

/**
   Ten program zapisuje dane w pliku. Przed otwarciem pliku
   program sprawdza, czy plik o danej nazwie nie   istnieje.
*/

public class FileWriteDemo2
{
   public static void main(String[] args) throws IOException
   {
      String filename;      // Nazwa pliku.
     String friendName;  // Imi znajomego.
     int numFriends;     // Liczba znajomych.

      // Tworzenie obiektu klasy Scanner do pobierania danych z klawiatury.
      Scanner keyboard = new Scanner(System.in);
      
      // Pobieranie liczby znajomych.
     System.out.print("Podaj liczb znajomych: ");
     numFriends = keyboard.nextInt();

     // Pobieranie pozostaego znaku nowego wiersza.
     keyboard.nextLine();

     // Pobieranie nazwy pliku.
     System.out.print("Podaj nazw pliku: ");
      filename = keyboard.nextLine();
      
      // Upewnianie si, e plik o danej nazwie nie istnieje.
     File file = new File(filename);
     if (file.exists())
     {
       System.out.println("Plik " + filename +
                          " ju istnieje.");
       System.exit(0);
     }

     // Otwieranie pliku.
      PrintWriter outputFile = new PrintWriter(file);

      // Pobieranie danych i zapisywanie ich w pliku.
     for (int i = 1; i <= numFriends; i++)
     {
       // Pobieranie imienia znajomego.
       System.out.print("Podaj imi znajomego " +
                        "numer " + i + ": ");
       friendName = keyboard.nextLine();

       // Zapis imienia w pliku.
         outputFile.println(friendName);
      }

      // Zamykanie pliku.
     outputFile.close();
     System.out.println("Dane zapisano w pliku.");
   }
}
