import javafx.application.Application;
import javafx.stage.Stage;
import javafx.scene.Scene;
import javafx.scene.layout.VBox;
import javafx.scene.control.Label;
import javafx.scene.control.Button;
import javafx.geometry.Pos;
import javafx.event.EventHandler;
import javafx.event.ActionEvent;

/**
 *  Obsuga przycisku za pomoc anonimowej klasy wewntrznej.
 */

public class AnnonInnerClassDemo extends Application
{
   public static void main(String[] args)
   {
      // Uruchamianie aplikacji.
      launch(args);
   }
   
   @Override
   public void start(Stage primaryStage)
   {
      // Tworzenie kontrolki typu Label.
      Label myLabel = new Label("Kliknij przycisk, aby zobaczy komunikat.");
      
      // Tworzenie kontrolki typu Button.
      Button myButton = new Button("Kliknij mnie");
      myButton.setOnAction(new EventHandler<ActionEvent>()
      {
         @Override
         public void handle(ActionEvent event)
         {
            myLabel.setText("Dzikujemy za kliknicie przycisku.");
         }
      });
      
      // Umieszczanie etykiety i przycisku w kontenerze typu VBox z odstpami 10 pikseli.
      VBox vbox = new VBox(10, myLabel, myButton);
      
      // Tworzenie sceny z kontenerem typu VBox jako wzem korzenia.
      Scene scene = new Scene(vbox, 300, 100);
      
      // Wyrodkowanie zawartoci sceny.
      vbox.setAlignment(Pos.CENTER);
      
      // Dodawanie sceny do ptna.
      primaryStage.setScene(scene);
      
      // Okrelanie tytuu ptna.
      primaryStage.setTitle("Demonstracja dziaania przycisku");
      
      // Wywietlanie okna.
      primaryStage.show();
   }
}