import java.io.*;
import java.util.Scanner;

/**
   Ten program serializuje elementy tablicy
   obiektw typu BankAccount2.
*/

public class SerializeObjects
{
   public static void main(String[] args)
                      throws IOException
   {
      double balance;            // Stan konta.
      final int NUM_ITEMS = 3; // Liczba kont.

      // Tworzenie obiektu typu Scanner do pobierania danych z klawiatury.
      Scanner keyboard = new Scanner(System.in);
            
      // Tworzenie tablicy elementw typu BankAccount2.
      BankAccount2[] accounts =
                    new BankAccount2[NUM_ITEMS];
      
      // Zapenianie tablicy.
     for (int i = 0; i < accounts.length; i++)
     {
       // Pobieranie stanu konta.
       System.out.print("Podaj stan konta " +
                        "numer " + (i + 1) + ": ");
       balance = keyboard.nextDouble();

       // Tworzenie obiektu w tablicy.
         accounts[i] = new BankAccount2(balance);
      }
      
      // Tworzenie obiektw strumieni.
      FileOutputStream outStream = 
                new FileOutputStream("Objects.dat");
      ObjectOutputStream objectOutputFile = 
                new ObjectOutputStream(outStream);
      
      // Zapisywanie zserializowanych obiektw w pliku.
      for (int i = 0; i < accounts.length; i++)
      {
         objectOutputFile.writeObject(accounts[i]);
      }
      
      // Zamykanie pliku.
      objectOutputFile.close();

      System.out.println("Zserializowane obiekty " +
           "zostay zapisane w pliku Objects.dat.");
   }
}
