import java.io.*;
import java.util.Scanner;

/**
   Klasa TestScoreReader wczytuje wyniki testw
   jako tokeny z pliku i oblicza redni 
   dla kadego wiersza wynikw.
*/

public class TestScoreReader
{
   private Scanner inputFile;
   private String line;

   /**
      Konstruktor otwiera plik w celu
      wczytania z niego ocen.
      @param filename Otwierany plik.
   */
   
   public TestScoreReader(String filename)
                        throws IOException
   {
      File file = new File(filename);
      inputFile = new Scanner(file);
   }
   
   /**
      Metoda readNextLine wczytuje z pliku
      nastpny wiersz.
      @return true, jeli wczytano wiersz, false
              w przeciwnym razie.
   */

   public boolean readNextLine() throws IOException
   {
      boolean lineRead; // Flaga.

      // Okrelanie, czy pozostay jakie dane do wczytania.
      lineRead = inputFile.hasNext();

      // Jeli pozostay, naley wczyta nastpny wiersz.
      if (lineRead)
        line = inputFile.nextLine();
       
      return lineRead;
   }

   /**
      Metoda getAverage oblicza redni ostatniego
      zestawu wynikw testw wczytanego z pliku.
      @return rednia.
   */
    
   public double getAverage()
   {
      int total = 0;    // Akumulator.
      double average; // rednia wynikw testw.

      // Podzia ostatniego wczytanego wiersza z pliku na tokeny.
      String[] tokens = line.split(",");
 
      // Obliczanie sumy wynikw testw.
      for (String str : tokens)
      {
         total += Integer.parseInt(str);
      }
    
      // Obliczanie redniej wynikw.
      // Rzutowanie w celu uniknicia dzielenia cakowitoliczbowego.
      average = (double) total / tokens.length;

      // Zwracanie redniej.
      return average;
   }
   
   /**
      Metoda close zamyka plik.
   */
   
   public void close() throws IOException
   {
      inputFile.close();
   }
}