/**
   Klasa Stock przechowuje dane dotyczce akcji.
*/

public class Stock
{
   private String symbol;     // Symbol giedowy.
   private double sharePrice;  // Aktualna cena akcji.
   
   /**
     Konstruktor
     @param sym Symbol giedowy.
     @param price Cena akcji.
   */

   public Stock(String sym, double price)
   {
      symbol = sym;
      sharePrice = price;
   }
   
   /**
      Metoda getSymbol.
      @return Symbol giedowy.
   */
   
   public String getSymbol()
   {
      return symbol;
   }
   
   /**
      Metoda getSharePrice.
      @return Cena akcji.
   */
   
   public double getSharePrice()
   {
      return sharePrice;
   }

   /**
      Metoda toString.
      @return acuch znakw zawierajcy
            kod i cen akcji.
   */
   
   public String toString()
   {
      // Tworzenie acucha znakw opisujcego akcje.
      String str = "Symbol giedowy: " + symbol +
                   "\nCena akcji: " + sharePrice;
 
      // Zwracanie acucha znakw.
      return str;
   }

   /**
      Metoda equals porwnuje dwa obiekty typu Stock.
      @param object2 Obiekt typu Stock porwnywany z 
                     obiektem typu Stock, ktry wywoa metod.
      @return true, jeli obiekt podany jako argument jest rwny
              obiektowi, ktry wywoa metod.
   */

   public boolean equals(Stock object2)
   {
      boolean status;
      
      // Okrelanie, czy pola symbol i sharePrice
      // danego obiektu s rwne wzgldem pl
      // symbol i sharePrice obiektu object2.
      if (symbol.equals(object2.symbol) &&
        sharePrice == object2.sharePrice)
        status = true;  // Tak, obiekty s sobie rwne.
      else
        status = false; // Nie, obiekty nie s sobie rwne.

      // Zwracanie wartoci zmiennej status.
      return status;
   }

   /**
      Metoda copy tworzy kopi obiektu typu Stock.
      @return Referencja do kopii obiektu, ktry wywoa metod.
   */

   public Stock copy()
   {
      // Tworzenie nowego obiektu typu Stock i inicjowanie
      // go danymi przechowywanymi w obiekcie zawierajcym wywoan metod.
      Stock copyObject = new Stock(symbol, sharePrice);

      // Zwracanie referencji do nowego obiektu.
      return copyObject;
   }
}
