package javaxml3;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Enumeration;

public class TestXMLProperties {

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Usage: java javaxml3.TestXMLProperties " +
                "[XML input document] [XML output document]");
            System.exit(0);
        }
    
        try {
            // Utworzenie i zaadowanie waciwoci.
            System.out.println("Reading XML properties from " + args[0]);
            XMLProperties props = new XMLProperties();
            props.load(new FileInputStream(args[0]));
            
            // Wydruk waciwoci i wartoci.
            System.out.println("\n\n---- Wartoci waciwoci ----");
            Enumeration names = props.propertyNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                String value = props.getProperty(name);
                System.out.println("Waciwo o nazwie: " + name + 
                                   " ma warto " + value);
            }

			// Zapisywanie waciwoci.
			System.out.println("\n\nZapis waciwoci XML do " + args[1]);
            props.store(new FileOutputStream(args[1]),
                "Testowanie klasy XMLProperties.");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
