package javaxml3;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;

import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class PropsToXML {

	/**
	 * <p> Dostarczenie statycznego punktu wejciowego do dziaania. </p>
	 */

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Usage: java javaxml3.PropsToXML "
                    + "[properties file] [XML file for output]");
            System.exit(0);
        }

        try {
            PropsToXML propsToXML = new PropsToXML();
            propsToXML.convert(args[0], args[1]);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

	/**
   * <p> Klasa ta pobierze dostarczony plik waciwoci i
   *   przekonwertuje jego tre na XML, ktra nastpnie zostanie
   *   wysana do pliku XML o podanej nazwie.</p>
   *
   * @param propertiesFilename plik do wczytania jako waciwoci Java.
   * @param xmlFilename plik, do ktrego dane XML maj zosta wysane.
   * @throws <code>IOException</code> - kiedy wystpi jakie bdy.
   */

    public void convert(String propertiesFilename, String xmlFilename)
            throws IOException {

		// Uzyskanie obiektu Properties.
        FileInputStream input = new FileInputStream(propertiesFilename);
        Properties props = new Properties();
        props.load(input);

		// Konwersja na XML.
        convertToXML(props, xmlFilename);
    }

	/**
	  * <p>Obsuga konwersji z waciwoci Javy w obiekcie
	  *  <code>Properties</code> na dokument XML. </p>
	  *
	  * @param props obiekt <code>Properties</code>, ktry ma zosta uyty na wejciu.
	  * @param xmlFilename plik, do ktrego ma by wysany kod XML.
	  * @throws <code>IOException</code> - gdy wystpi bdy.
	  */

    private void convertToXML(Properties props, String xmlFilename)
            throws IOException {

		// Utworzenie nowego obiektu JDOM Document z elementem korzenia "properties".
        Element root = new Element("properties");
        Document doc = new Document(root);

		// Wydobycie nazw waciwoci.
        Enumeration propertyNames = props.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String propertyName = (String) propertyNames.nextElement();
            String propertyValue = props.getProperty(propertyName);
            createXMLRepresentation(root, propertyName, propertyValue);
        }

		// Wysanie dokumentu do pliku o podanej nazwie.
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        FileOutputStream output = new FileOutputStream(xmlFilename);
        outputter.output(doc, output);

    }

	/**
   * <p> Konwersja pojedynczej waciwoci i jej wartoci na
   *  element XML i warto tekstow. </p>
   *
   * @param root Korze JDOM <code>Element</code>, do ktrego bd dodawane elementy potomne.
   * @param propertyName nazwa tworzonego elementu.
   * @param propertyValue warto dla waciwoci.
   */

    private void createXMLRepresentation(Element root, String propertyName,
            String propertyValue) {

        /* 
        Element element = new Element(propertyName);
        element.setText(propertyValue);
        root.addContent(element);
        */
 
        int split;
        String name = propertyName;
        Element current = root;
        Element test = null;
 
        while ((split = name.indexOf(".")) != -1) {
            String subName = name.substring(0, split);
            name = name.substring(split+1);

			// Sprawdzanie czy element istnieje. 
            if ((test = current.getChild(subName)) == null) {
                Element subElement = new Element(subName);
                current.addContent(subElement);
                current = subElement;
            } else {
                current = test;
            }
        }

		// Kiedy poza ptl, to co zostao stanowi kocow nazw elementu.
        Element last = new Element(name); 
        last.setText(propertyValue);
        //Attribute attribute = new Attribute("value", propertyValue);
        //last.setAttribute(attribute);
        current.addContent(last);

    }

}
