<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:output method="html"/>
  <xsl:variable name="title" select="/rss/channel/title"/>
  <xsl:template match="/">
    <xsl:element name="html">
      <head>
        <title>
          <xsl:value-of select="$title"/>
        </title>
      </head>
      <xsl:apply-templates select="rss/channel"/>
    </xsl:element>
  </xsl:template>
  <xsl:template match="channel">
    <body>
      <div>
        <div>
          <h1>
            <xsl:value-of select="$title"/>
          </h1>
        </div>
        <div>
          <xsl:apply-templates select="item"/>
        </div>
      </div>
    </body>
  </xsl:template>
  <xsl:template match="item">
    <xsl:if test="position() = 1">
      <h3>Aktualna treść źródła</h3>
    </xsl:if>
    <ul>
      <li>
        <h4>
          <a href="{link}">
            <xsl:value-of select="title"/>
          </a>
        </h4>
        <div class="itemcontent" name="decodeable">
          <xsl:value-of select="description" disable-output-escaping="yes"/>
        </div>
      </li>
    </ul>
  </xsl:template>
</xsl:stylesheet>
