package javaxml3.icbm.io;

import javaxml3.icbm.ICBMModule;
import javaxml3.icbm.ICBMModuleImpl;

import org.jdom.Element;
import org.jdom.Namespace;

import com.sun.syndication.feed.module.Module;
import com.sun.syndication.io.ModuleParser;

public class ICBMParser implements ModuleParser {

    private static final Namespace NS = Namespace.getNamespace(ICBMModule.URI);

    public String getNamespaceUri() {
        return ICBMModule.URI;
    }

    public Module parse(Element element) {
        boolean foundSomething = false;
        ICBMModuleImpl icbm = new ICBMModuleImpl();

        Element e = element.getChild("latitude", NS);
        if (e != null) {
            try {
                icbm.setLatitude(Float.parseFloat(e.getText()));
                foundSomething = true;
            } catch (NumberFormatException ex) {
                // Nie rb nic.
            }
        }

        if (foundSomething) {
            e = element.getChild("longitude", NS);
            if (e != null) {
                try {
                    icbm.setLongitude(Float.parseFloat(e.getText()));
                } catch (NumberFormatException ex) {
					// Nie mona mie szerokoci bez dugoci geograficznej.
                    foundSomething = false;
                }
            } else {
				// Nie mona mie dugoci bez szerokoci geograficznej.
                foundSomething = false;
            }
        }

        return (foundSomething) ? icbm : null;
    }

}
