package javaxml3;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Collections;
import java.util.Date;
import java.util.List;

import com.sun.syndication.feed.WireFeed;
import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.sun.syndication.feed.synd.SyndPerson;
import com.sun.syndication.feed.synd.SyndPersonImpl;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.WireFeedOutput;

public class ExampleRomeOutput {

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err
                    .println("Uycie: java javaxml3.ExampleRomeOutput [feedtype]");
            return;
        }

        SyndPerson author = new SyndPersonImpl();
        author.setEmail("editor@przyklad.org");
        author.setName("Przykadowa Osoba");

        SyndFeed feed = new SyndFeedImpl();
		feed.setTitle("Przykadowe rdo wysane przez ROME.");
		feed.setDescription("Strona przykadowej organizacji.");
        feed.setAuthors(Collections.singletonList(author));
        feed.setLink("http://www.przyklad.org/");
        feed.setPublishedDate(new Date());

        SyndEntry entry = new SyndEntryImpl();
		entry.setTitle("Tytu pierwszego wpisu.");
        entry.setLink("http://www.przyklad.org/item1");
        SyndContent description = new SyndContentImpl();
		description.setValue("Wiadomoci o projekcie Przykad.");
        description.setType("text");
        entry.setDescription(description);
        entry.setAuthors(Collections.singletonList(author));
        feed.getEntries().add(entry);

        entry = new SyndEntryImpl();
		entry.setTitle("Tytu drugiego wpisu.");
        entry.setLink("http://www.przyklad.org/item2");
        description = new SyndContentImpl();
		description.setValue("<i>Wicej</i> wiadomoci o projekcie Przykad.");
        description.setType("html");
        entry.setDescription(description);
        entry.setAuthors(Collections.singletonList(author));
        feed.getEntries().add(entry);

        List supportedTypes = feed.getSupportedFeedTypes();
        String feedType = args[0];
        if (!supportedTypes.contains(feedType)) {
			System.err.println("Nieobsugiwany typ rda.");
			System.err.println("Obsugiwane typy rde to: "
                    + supportedTypes.toString());
            return;
        }

        WireFeed rssFeed = feed.createWireFeed(feedType);

        WireFeedOutput output = new WireFeedOutput();
        try {
            output.output(rssFeed, new OutputStreamWriter(System.out));
        } catch (IOException e) {
            System.err.println("Nie mona wysa rda: " + e.getMessage());
            e.printStackTrace();
        } catch (FeedException e) {
            System.err.println("Nie mona wygenerowa rda: " + e.getMessage());
            e.printStackTrace();
        }

    }

}
