package javaxml3.ch13;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class BookListXMLServlet extends HttpServlet
{

	private DocumentBuilderFactory documentBuilderFactory;

	private TransformerFactory transformerFactory;

	public void init()
	{
		documentBuilderFactory = DocumentBuilderFactory.newInstance();
		transformerFactory = TransformerFactory.newInstance();
	}

	private Element newElementFromMap(Map map, String key, Document doc)
	{
		String text = (String)map.get(key);
		Text textNode = doc.createTextNode(text);
		Element element = doc.createElement(key);
		element.appendChild(textNode);
		return element;
	}

	protected void renderDocument(Document doc, HttpServletRequest request,
			HttpServletResponse response) throws IOException, ServletException
	{

		// Informacja dla przegldarki, e wysyany jest XML.
		response.setContentType("text/xml");

		// Transformacja identycznociowa.
		try
		{
			Transformer identity = transformerFactory.newTransformer();

			// Nasz obiekt Result to StreamResult opakowujcy
			// ServletOutputStream.
			Result result = new StreamResult(response.getOutputStream());
			identity.transform(new DOMSource(doc), result);
		}
		catch (TransformerException e)
		{
			throw new ServletException(
					"Nie mona wykona transformacji identycznociowej", e);
		}
	}

	protected void service(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException
	{
		List bookList = BookListFactory.INSTANCE;

		DocumentBuilder docBuilder = null;
		try
		{
			docBuilder = documentBuilderFactory.newDocumentBuilder();
		}
		catch (ParserConfigurationException e)
		{
			throw new ServletException(
					"Nie mona utworzy DocumentBuilderFactory", e);
		}

		// Tworzenie dokumentu DOM.
		Document doc = docBuilder.newDocument();
		Element books = doc.createElement("books");
		doc.appendChild(books);
		for (Iterator it = bookList.iterator(); it.hasNext(); )
		{
			Map bookMap = (Map)it.next();
			Element book = doc.createElement("book");
			books.appendChild(book);
			book.appendChild(newElementFromMap(bookMap,
					BookListConstants.TITLE, doc));
			book.appendChild(newElementFromMap(bookMap,
					BookListConstants.AUTHOR, doc));
			book.appendChild(newElementFromMap(bookMap,
					BookListConstants.PUBDATE, doc));
		}

		renderDocument(doc, request, response);
	}
}

class BookListConstants
{

	public static final String AUTHOR = "author";

	public static final String PUBDATE = "pubdate";

	public static final String TITLE = "title";
}
class BookListFactory
{

	public static final List INSTANCE;

	static
	{
		List templist = new ArrayList();
		Map m = new HashMap();
		m.put(BookListConstants.TITLE, "Ajax Hacks");
		m.put(BookListConstants.AUTHOR, "Bruce W. Perry");
		m.put(BookListConstants.PUBDATE, "merzec 2006");
		templist.add(m);

		m = new HashMap();
		m.put(BookListConstants.TITLE, "LDAP System Administration");
		m.put(BookListConstants.AUTHOR, "Gerald Carter");
		m.put(BookListConstants.PUBDATE, "marzec 2003");
		templist.add(m);

		m = new HashMap();
		m.put(BookListConstants.TITLE, "Java Servlet Programming");
		m.put(BookListConstants.AUTHOR, "Jason Hunter");
		m.put(BookListConstants.PUBDATE, "kwiecie 2001");
		templist.add(m);

		INSTANCE = Collections.unmodifiableList(templist);
	}

	private BookListFactory()
	{
	}

}
