package javaxml3;

import java.io.OutputStreamWriter;
import java.util.Collections;
import java.util.Date;
import java.util.List;

import javaxml3.icbm.ICBMModule;
import javaxml3.icbm.ICBMModuleImpl;

import com.sun.syndication.feed.WireFeed;
import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.sun.syndication.feed.synd.SyndPerson;
import com.sun.syndication.feed.synd.SyndPersonImpl;
import com.sun.syndication.io.WireFeedOutput;

public class ICBMExample {
    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err
                    .println("Uycie: java javaxml3.ExampleRomeOutput [feedtype]");
            args = new String[] { "rss_2.0" };
        }

        SyndPerson author = new SyndPersonImpl();
        author.setEmail("editor@przyklad.org");
        author.setName("Przykadowa Osoba");

        SyndFeed feed = new SyndFeedImpl();
		feed.setTitle("Przykadowe rdo wysane przez ROME.");
		feed.setDescription("Strona przykadowej organizacji.");
        feed.setAuthors(Collections.singletonList(author));
        feed.setLink("http://www.przyklad.org/");
        feed.setPublishedDate(new Date());

        SyndEntry entry = new SyndEntryImpl();
		entry.setTitle("Tytu pierwszego wpisu.");
        entry.setLink("http://www.przyklad.org/item1");
        SyndContent description = new SyndContentImpl();
		description.setValue("Wiadomoci o projekcie Przykad.");
        description.setType("text");
        entry.setDescription(description);
        entry.setAuthors(Collections.singletonList(author));

        ICBMModule icbm = new ICBMModuleImpl();
        icbm.setLatitude(39.02980f);
        icbm.setLongitude(-77.07929f);
        entry.getModules().add(icbm);

        feed.getEntries().add(entry);
        
        WireFeed rssFeed = feed.createWireFeed(args[0]);

        WireFeedOutput output = new WireFeedOutput();
        output.output(rssFeed, new OutputStreamWriter(System.out));

    }
}
