package javaxml3;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Enumeration;

public class TestDom4jXMLProperties {

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Usage: java javaxml3.TestDom4jXMLProperties " +
                "[XML input document] [XML output document]");
            System.exit(0);
        }
    
        try {
            // Utworzenie i zaadowanie waciwoci.
            System.out.println("Wczytywanie waciwoci XML z " + args[0]);
            Dom4jXMLProperties props = new Dom4jXMLProperties();
            props.load(new FileInputStream(args[0]));
            
            // Print out properties and values
            System.out.println("\n\n---- Wartoci waciwoci ----");
            Enumeration names = props.propertyNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                String value = props.getProperty(name);
                System.out.println("Waciwo o nazwie: " + name + 
                                   " ma warto " + value);
            }            
            
            // Store properties
            System.out.println("\n\nZapisywanie waciwoci XML do " + args[1]);
            props.store(new FileOutputStream(args[1]),
                "Testowanie klasy XMLProperties.");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
