package server;

import java.io.*;
import java.net.*;
import java.util.*;

/**
 * Program implementujący prosty serwer nasłuchujący na porcie 8189
 * i wysyłający echo informacji otrzymanej od klienta.
 * @version 1.21 2012-05-19
 * @author Cay Horstmann
 */
public class EchoServer
{
   public static void main(String[] args) throws IOException
   {
      // tworzy gniazdo serwera
      try (ServerSocket s = new ServerSocket(8189))
      {
         // oczekuje na połączenie z klientem
         try (Socket incoming = s.accept())
         {
            InputStream inStream = incoming.getInputStream();
            OutputStream outStream = incoming.getOutputStream();
   
            try (Scanner in = new Scanner(inStream, "UTF-8"))
            {
               PrintWriter out = new PrintWriter(
                  new OutputStreamWriter(outStream, "UTF-8"),
                  true /* autoFlush */);
      
               out.println("Witaj! Wpisz BYE, by zakończyć.");
      
               // wysyła echo informacji otrzymanej od klienta
               boolean done = false;
               while (!done && in.hasNextLine())
               {
                  String line = in.nextLine();
                  out.println("Echo: " + line);
                  if (line.trim().equals("BYE")) done = true;
               }
            }
         }
      }
   }
}
