package imageTransfer;

import java.awt.*;
import java.awt.datatransfer.*;

/**
 * Ta klasa to opakowanie do transferu danych obiektów obrazów.
 */
public class ImageTransferable implements Transferable
{
   private Image theImage;

   /**
    * Tworzy zaznaczenie.
    * @param image obraz
    */
   public ImageTransferable(Image image)
   {
      theImage = image;
   }

   public DataFlavor[] getTransferDataFlavors()
   {
      return new DataFlavor[] { DataFlavor.imageFlavor };
   }

   public boolean isDataFlavorSupported(DataFlavor flavor)
   {
      return flavor.equals(DataFlavor.imageFlavor);
   }

   public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException
   {
      if (flavor.equals(DataFlavor.imageFlavor))
      {
         return theImage;
      }
      else
      {
         throw new UnsupportedFlavorException(flavor);
      }
   }
}
