package desktopApp;

import java.awt.*;
import java.io.*;
import java.net.*;

import javax.swing.*;

class DesktopAppFrame extends JFrame
{
   public DesktopAppFrame()
   {
      setLayout(new GridBagLayout());
      final JFileChooser chooser = new JFileChooser();
      JButton fileChooserButton = new JButton("...");
      final JTextField fileField = new JTextField(20);
      fileField.setEditable(false);
      JButton openButton = new JButton("Otwórz");
      JButton editButton = new JButton("Edytuj");
      JButton printButton = new JButton("Drukuj");
      final JTextField browseField = new JTextField();
      JButton browseButton = new JButton("Przeglądaj");
      final JTextField toField = new JTextField();
      final JTextField subjectField = new JTextField();
      JButton mailButton = new JButton("E-mail");

      openButton.setEnabled(false);
      editButton.setEnabled(false);
      printButton.setEnabled(false);
      browseButton.setEnabled(false);
      mailButton.setEnabled(false);

      if (Desktop.isDesktopSupported())
      {
         Desktop desktop = Desktop.getDesktop();
         if (desktop.isSupported(Desktop.Action.OPEN)) openButton.setEnabled(true);
         if (desktop.isSupported(Desktop.Action.EDIT)) editButton.setEnabled(true);
         if (desktop.isSupported(Desktop.Action.PRINT)) printButton.setEnabled(true);
         if (desktop.isSupported(Desktop.Action.BROWSE)) browseButton.setEnabled(true);
         if (desktop.isSupported(Desktop.Action.MAIL)) mailButton.setEnabled(true);
      }

      fileChooserButton.addActionListener(event ->
         {
            if (chooser.showOpenDialog(DesktopAppFrame.this) == JFileChooser.APPROVE_OPTION)
               fileField.setText(chooser.getSelectedFile().getAbsolutePath());
         });

      openButton.addActionListener(event ->
         {
            try
            {
               Desktop.getDesktop().open(chooser.getSelectedFile());
            }
            catch (IOException ex)
            {
               ex.printStackTrace();
            }
         });

      editButton.addActionListener(event ->
         {
            try
            {
               Desktop.getDesktop().edit(chooser.getSelectedFile());
            }
            catch (IOException ex)
            {
               ex.printStackTrace();
            }
         });

      printButton.addActionListener(event ->
         {
            try
            {
               Desktop.getDesktop().print(chooser.getSelectedFile());
            }
            catch (IOException ex)
            {
               ex.printStackTrace();
            }
         });

      browseButton.addActionListener(event ->
         {
            try
            {
               Desktop.getDesktop().browse(new URI(browseField.getText()));
            }
            catch (URISyntaxException | IOException ex)
            {
               ex.printStackTrace();
            }
         });

      mailButton.addActionListener(event ->
         {
            try
            {
               String subject = percentEncode(subjectField.getText());
               URI uri = new URI("mailto:" + toField.getText() + "?subject=" + subject);

               System.out.println(uri);
               Desktop.getDesktop().mail(uri);
            }
            catch (URISyntaxException | IOException ex)
            {
               ex.printStackTrace();
            }
         });

      JPanel buttonPanel = new JPanel();
      ((FlowLayout) buttonPanel.getLayout()).setHgap(2);
      buttonPanel.add(openButton);
      buttonPanel.add(editButton);
      buttonPanel.add(printButton);

      add(fileChooserButton, new GBC(0, 0).setAnchor(GBC.EAST).setInsets(2));
      add(fileField, new GBC(1, 0).setFill(GBC.HORIZONTAL));
      add(buttonPanel, new GBC(2, 0).setAnchor(GBC.WEST).setInsets(0));
      add(browseField, new GBC(1, 1).setFill(GBC.HORIZONTAL));
      add(browseButton, new GBC(2, 1).setAnchor(GBC.WEST).setInsets(2));
      add(new JLabel("Do:"), new GBC(0, 2).setAnchor(GBC.EAST).setInsets(5, 2, 5, 2));
      add(toField, new GBC(1, 2).setFill(GBC.HORIZONTAL));
      add(mailButton, new GBC(2, 2).setAnchor(GBC.WEST).setInsets(2));
      add(new JLabel("Temat:"), new GBC(0, 3).setAnchor(GBC.EAST).setInsets(5, 2, 5, 2));
      add(subjectField, new GBC(1, 3).setFill(GBC.HORIZONTAL));

      pack();
   }

   private static String percentEncode(String s)
   {
      try
      {
         return URLEncoder.encode(s, "UTF-8").replaceAll("[+]", "%20");
      }
      catch (UnsupportedEncodingException ex)
      {
         return null; // UTF-8 jest zawsze obsługiwany
      }
   }
}