/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.verifier.structurals;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.generic.CodeExceptionGen;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.verifier.structurals.ExceptionHandler;

public class ExceptionHandlers {
    private Map<InstructionHandle, Set<ExceptionHandler>> exceptionhandlers = new HashMap<InstructionHandle, Set<ExceptionHandler>>();

    public ExceptionHandlers(MethodGen mg) {
        CodeExceptionGen[] cegs = mg.getExceptionHandlers();
        for (int i = 0; i < cegs.length; ++i) {
            ExceptionHandler eh = new ExceptionHandler(cegs[i].getCatchType(), cegs[i].getHandlerPC());
            for (InstructionHandle ih = cegs[i].getStartPC(); ih != cegs[i].getEndPC().getNext(); ih = ih.getNext()) {
                Set<ExceptionHandler> hs = this.exceptionhandlers.get(ih);
                if (hs == null) {
                    hs = new HashSet<ExceptionHandler>();
                    this.exceptionhandlers.put(ih, hs);
                }
                hs.add(eh);
            }
        }
    }

    public ExceptionHandler[] getExceptionHandlers(InstructionHandle ih) {
        Set<ExceptionHandler> hs = this.exceptionhandlers.get(ih);
        if (hs == null) {
            return new ExceptionHandler[0];
        }
        ExceptionHandler[] ret = new ExceptionHandler[hs.size()];
        return hs.toArray(ret);
    }
}

