package com.horstmann.corejava;

import java.awt.*;
import java.beans.*;

/**
 * Klasa informacyjna ziarnka wykresu, 
 * okrelajca jego ikon oraz klas indywidualizacji.
 * @version 1.30 2007-10-05
 * @author Cay Horstmann
 */
public class ChartBean2BeanInfo extends SimpleBeanInfo
{
   public ChartBean2BeanInfo()
   {
      beanDescriptor = new BeanDescriptor(ChartBean2.class, ChartBean2Customizer.class);
   }
   
   public BeanDescriptor getBeanDescriptor()
   {
      return beanDescriptor;
   }

   public Image getIcon(int iconType)
   {
      if (iconType == BeanInfo.ICON_COLOR_16x16) return iconColor16;
      else if (iconType == BeanInfo.ICON_COLOR_32x32) return iconColor32;
      else if (iconType == BeanInfo.ICON_MONO_16x16) return iconMono16;
      else if (iconType == BeanInfo.ICON_MONO_32x32) return iconMono32;
      else return null;
   }

   private BeanDescriptor beanDescriptor;
   private Image iconColor16;
   private Image iconColor32;
   private Image iconMono16;
   private Image iconMono32;
}
