package com.horstmann.corejava;

import java.beans.*;

/**
 * A custom editor for the titlePosition property of the ChartBean. The editor lets the user choose
 * between Left, Center, and Right
 * @version 1.11 2004-08-30
 * @author Cay Horstmann
 */
public class TitlePositionEditor extends PropertyEditorSupport
{
   public String[] getTags()
   {
      return options;
   }

   private String[] options = { "Left", "Center", "Right" };

   public String getJavaInitializationString()
   {
      return ChartBean.Position.class.getName().replace('$', '.') + "." + getValue();
   }

   public String getAsText()
   {
      int value = ((ChartBean.Position) getValue()).ordinal();
      return options[value];
   }

   public void setAsText(String s)
   {
      for (int i = 0; i < options.length; i++)
      {
         if (options[i].equals(s))
         {
            setValue(ChartBean.Position.valueOf(options[i].toUpperCase()));
            return;
         }
      }
   }
}
